



<html>
<head>
  <title>javabog.dk -  - Optimering</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">9 <a name='afsn9'></a>Optimering</H1>
<DIV ID="Indholdsfortegnelse16">
  <P STYLE="margin-top: 0.3cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>9.1
  Optimering  140</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>9.2
  Ting, man skal undg&aring; (hvis man kan)  140</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.2.1
  Oprette mange objekter  140</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.2.2
  Oprette mange tr&aring;de  141</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.2.3
  Kaste og fange mange undtagelser  141</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.2.4
  G&aring; ind og ud af synkroniserede blokke/metoder  141</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.2.5
  Bruge mange (evt. anonyme) klasser  141</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>9.3
  Er C++ hurtigere end Java?  142</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.3.1
  Et testprogram i Java  143</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">9.3.2
  Testprogrammet i C++  143</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>9.4
  Videre l&aelig;sning  144</B></FONT></FONT></P>
</DIV>


<H2 CLASS="western" STYLE="">9.1 <a name='afsn9.1'></a>Optimering</SPAN></H2>
<P CLASS="western">Et programs ydeevne begr&aelig;nses n&aelig;sten
altid af h&oslash;jst to-tre faktorer (flaskehalse).</P>
<P CLASS="western">Inden du l&aelig;ser videre, s&aring; bem&aelig;rk
lige en generel regel omkring optimering af ydelse:</P>
<BLOCKQUOTE CLASS="definition-western">Under programmeringen er det i
de fleste tilf&aelig;lde spild af tid at t&aelig;nke p&aring;
optimering - det er bedre at koncentrere sig om funktionaliteten og,
n&aring;r programmet er skrevet n&aelig;sten helt f&aelig;rdigt,
identificere flaskehalsene og optimere disse dele af koden 
</BLOCKQUOTE>
<P CLASS="western">Optimering af k&oslash;rselstiden b&oslash;r dog
ske tidligere, hvis:</P>
<UL>
  <LI><P CLASS="western">Det forventes at for&aring;rsage st&oslash;rre
  strukturelle &aelig;ndringer i programmet. Optimeringer der
  forventes at indvirke p&aring; programmets struktur, b&oslash;r ske
  i design-fasen, inden programmeringen p&aring;begyndes.</P>
  <LI><P CLASS="western">Det forventes at give kortere udviklingstid
  (fordi de l&oslash;bende afpr&oslash;vninger af programmet kan
  udf&oslash;res hurtigere).</P>
</UL>
<H2 CLASS="western">9.2 <a name='afsn9.2'></a>Ting, man skal undg&aring; (hvis man kan)</SPAN></H2>
<P CLASS="western">Man skal s&aring; vidt muligt undg&aring; at:</P>
<H3 CLASS="western">9.2.1 <a name='afsn9.2.1'></a>Oprette mange objekter</H3>
<P CLASS="western">Det tager b&aring;de tid at oprette dem, og det
tager ogs&aring; tid for den virtuelle maskine at finde og frigive
objekter, der ikke mere er i brug. Genbrug, objekterne hvis det er
muligt.</P>
<H4 CLASS="western">Eksempel: Streng-manipulation</H4>
<P CLASS="western">Skal du s&aelig;tte mange strenge sammen, b&oslash;r
du bruge en StringBuffer, da du s&aring; undg&aring;r at oprette de
mange midlertidige String-objekter, der ellers ville opst&aring;. 
</P>
<P CLASS="western">F&oslash;lgende program demonstrerer den enorme
hastighedsforskel, en StringBuffer kan g&oslash;re.</P>
<PRE CLASS="kode-western"><I>// Demonstrerer hastighedsforskellen mellem String og StringBuffer </I>
<SPAN LANG="da-DK"><I>// ved sammens&aelig;tning af mange strenge</I></SPAN>
<SPAN LANG="da-DK">public class HastighedsforskelMellemStringOgStringBuffer</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main (String[] arg)</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    long tid1 = System.currentTimeMillis();</SPAN>

<SPAN LANG="da-DK">    String s = &quot;&quot;;</SPAN>
<SPAN LANG="da-DK">    for (int i=0; i&lt;10000; i++) <B>s = s + &quot;x&quot;</B>;   <I>// her oprettes 10000 objekter</I></SPAN>

<SPAN LANG="da-DK">    long tid2 = System.currentTimeMillis();</SPAN>
<SPAN LANG="da-DK">    System.out.println(&quot;Antal sekunder med String: &quot;+ (tid2-tid1)*0.001 );</SPAN>

<SPAN LANG="da-DK">    StringBuffer <B>sb = new StringBuffer(10000)</B>; <I>// reserv&eacute;r plads til 10000 tegn</I></SPAN>
<SPAN LANG="da-DK">    for (int i=0; i&lt;10000; i++) <B>sb.append(&quot;x&quot;)</B>;<I>// her &aelig;ndres i det samme objek</I>t</SPAN>
<SPAN LANG="da-DK">    String s2 = <B>sb.toString()</B>;</SPAN>

<SPAN LANG="da-DK">    long tid3 = System.currentTimeMillis();</SPAN>
<SPAN LANG="da-DK">    System.out.println(&quot;Antal sek med StringBuffer: &quot;+ (tid3-tid2)*0.001 );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Antal sekunder med String: 3.432
<SPAN LANG="da-DK">Antal sek med StringBuffer: 0.021</SPAN></PRE><P CLASS="western">
Her sparer man alts&aring; over faktor 150 i k&oslash;rselstid (0.02
i stedet for 3.4 sekunder).</P>
<P CLASS="western">Besparelsen skyldes, at der oprettes f&aelig;rre
objekter (1 StringBuffer i stedet for 10000 strenge), og oprettelse
(og oprydning af) objekter er en forholdsvis tidskr&aelig;vende
operation.</P>
<H3 CLASS="western">9.2.2 <a name='afsn9.2.2'></a>Oprette mange tr&aring;de</H3>
<P CLASS="western">Tr&aring;de tager beslag p&aring; en del
systemresurser, s&aring; opret ikke alt for mange, og genbrug dem,
hvis det er muligt (se <a href='kapitel16.jsp#afsn16.7.3'>afsnit 16.7.3</a>, Genbrug af tr&aring;de).</P>
<H3 CLASS="western">9.2.3 <a name='afsn9.2.3'></a>Kaste og fange mange undtagelser</H3>
<P CLASS="western">Undtagelser er netop undtagelser, og den virtuelle
maskine udf&oslash;rer programmet hurtigst, hvis de ikke opst&aring;r.</P>
<H3 CLASS="western">9.2.4 <a name='afsn9.2.4'></a>G&aring; ind og ud af synkroniserede
blokke/metoder</H3>
<P CLASS="western">Hver gang en tr&aring;d g&aring;r ind i en
blok/metode m&aelig;rket med synchronized, skal den virtuelle maskine
tjekke, om der allerede er en tr&aring;d aktiv i denne blok. Den f&aring;r
alts&aring; noget ekstra arbejde, som tager tid.</P>
<H3 CLASS="western">9.2.5 <a name='afsn9.2.5'></a>Bruge mange (evt. anonyme) klasser</H3>
<P CLASS="western">Ved opstart indl&aelig;ses alle klasserne, som
programmet best&aring;r af eller har brug for, og det tager
selvf&oslash;lgelig tid. 
</P>
<P CLASS="western">Overraskende nok (for nogen) ligger indre klasser
og anonyme klasser <I>ikke</I> inde i den ydre klasse p&aring;
filsystemet, men skal indl&aelig;ses separat. 
</P>
<P CLASS="western">Bruger man derfor mange indre klasser eller
anonyme klasser, f.eks. i forbindelse med programmering af grafiske
brugergr&aelig;nseflader, b&oslash;r man overveje, om man kunne sl&aring;
nogen af dem sammen. 
</P>
<P CLASS="western">Hvis det drejer sig om h&aelig;ndelses-lyttere,
kunne man overveje at lade den ydre klasse lytte efter alle de
forskellige h&aelig;ndelser og droppe alle de anonyme klasser som et
GUI-udviklingsv&aelig;rkt&oslash;j typisk laver.</P>
<H4 CLASS="western">Eksempel</H4>
<P CLASS="western">I <a href='kapitel4.jsp#afsn4.1.3'>afsnit 4.1.3</a> Bruge en javab&oslash;nne er der et
eksempel p&aring; hvordan. F&oslash;rst er der et eksempel med en
anonym ActionListener-klasse (der er alts&aring; 2 klasser, der skal
indl&aelig;ses):</P>
<PRE CLASS="ikke-javakode-western">import java.awt.*;

<SPAN LANG="da-DK">public class BenytBoenneMedVaerktoej extends Frame</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK"><I>  ...</I></SPAN>

<SPAN LANG="da-DK">  public BenytBoenneMedVaerktoej()</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK"><I>    // anonym indre klasse lytter p&aring; h&aelig;ndelser og kalder derp&aring; videre til</I></SPAN>
<SPAN LANG="da-DK"><I>    // metoden textFieldNavn_actionPerformed()</I></SPAN>
<SPAN LANG="da-DK"><B>    textFieldNavn.addActionListener</B>(new ActionListener() {</SPAN>
<SPAN LANG="da-DK">      public void actionPerformed(ActionEvent e) {</SPAN>
<SPAN LANG="da-DK">        textFieldNavn_actionPerformed(e);</SPAN>
<SPAN LANG="da-DK">      }</SPAN>
<SPAN LANG="da-DK">    });</SPAN>
<SPAN LANG="da-DK"><I>    ...</I></SPAN>
<SPAN LANG="da-DK">  }</SPAN>

<SPAN LANG="da-DK">  void textFieldNavn_actionPerformed(ActionEvent e) {</SPAN>
<SPAN LANG="da-DK">    String navn = textFieldNavn.getText();</SPAN>
<SPAN LANG="da-DK">    System.out.println(&quot;Navnet er: &quot;+navn);</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<P CLASS="western" STYLE="">Efterf&oslash;lgende
blev den anonyme klasse sparet v&aelig;k ved at lade vinduet selv
implementere ActionListener (der er alts&aring; kun 1 klasse, der
skal indl&aelig;ses):</P>
<PRE CLASS="ikke-javakode-western">import java.awt.*;

<SPAN LANG="da-DK">public class BenytBoenneSkrevetSelv extends Frame <B>implements ActionListener</B></SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK"><I>  ...</I></SPAN>

<SPAN LANG="da-DK">  public BenytBoenneSkrevetSelv() {</SPAN>
<SPAN LANG="da-DK"><I>    // klassen selv lytter p&aring; h&aelig;ndelser</I></SPAN>
<SPAN LANG="da-DK"><B>    textFieldNavn.addActionListener(this)</B>;</SPAN>
<SPAN LANG="da-DK"><I>    ...</I></SPAN>
<SPAN LANG="da-DK">  }</SPAN>

<SPAN LANG="da-DK">  void actionPerformed(ActionEvent e) {</SPAN>
<SPAN LANG="da-DK">    String navn = textFieldNavn.getText();</SPAN>
<SPAN LANG="da-DK">    System.out.println(&quot;Navnet er: &quot;+navn);</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<H2 CLASS="western">9.3 <a name='afsn9.3'></a>Er C++ hurtigere end Java?</SPAN></H2>
<P CLASS="western">Det er en udbredt opfattelse, at C++ er hurtigere
end Java, og at C++ derfor er mere velegnet til programmer, der skal
foretage mange beregninger. 
</P>
<P CLASS="western">Det er imidlertid en myte, der slet ikke g&aelig;lder
for de nyere udgave af den virtuelle maskine (JDK 1.2 og derefter).</P>
<BLOCKQUOTE CLASS="definition-western">Et javaprogram laver
beregninger nogenlunde lige s&aring; hurtigt (eller hurtigere) som et
fuldt optimeret C++-program</BLOCKQUOTE>
<P CLASS="western">Myten stammer fra 1990-erne, f&oslash;r de
virtuelle maskiner fik implementeret JIT (Just In Time)-overs&aelig;ttelse.
JIT virker ved at overs&aelig;tte bytekoden til maskinkode,
efterh&aring;nden som den skal udf&oslash;res, s&aring;dan at der
bruges noget tid p&aring; JIT-overs&aelig;ttelse f&oslash;rste gang,
noget bytekode udf&oslash;res, derefter g&aring;r det lige s&aring;
hurtigt som maskinkode.</P>
<P CLASS="western">Almindelige C/C++-programmer (og Fortran- og
Pascal-programmer for den sags skyld) bliver oversat til maskinkode
&eacute;n gang for alle, hvorefter de kan k&oslash;res igen og igen. 
</P>
<P CLASS="western">Javaprogrammer bliver oversat til maskinkode af
den virtuelle maskine under k&oslash;rslen, hvilket naturligvis tager
mere tid f&oslash;rste gang, men i mods&aelig;tning til
C/C++-programmer kan JIT-overs&aelig;tteren v&aelig;lge at lave
maskinkoden afh&aelig;ngig af, hvordan k&oslash;rslen 'normalt'
foreg&aring;r.</P>

<H3 CLASS="western" STYLE="">9.3.1 <a name='afsn9.3.1'></a>Et
testprogram i Java</H3>
<P CLASS="western">Dette lille program finder alle primtal mellem
50000 og 100000. Der bruges ingen objekter:</P>
<PRE CLASS="kode-western">public class Primtal
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String[] args) {</SPAN>
<SPAN LANG="da-DK">    int antalPrimtal = 0;</SPAN>

<SPAN LANG="da-DK">    int tal;</SPAN>
<SPAN LANG="da-DK">    int faktor;</SPAN>

<SPAN LANG="da-DK">    for (tal = 50000; tal&lt;100000; tal++)</SPAN>
<SPAN LANG="da-DK">    {</SPAN>
<SPAN LANG="da-DK">      faktor = 2;</SPAN>

<SPAN LANG="da-DK">      while (tal % faktor &gt; 0) faktor++;</SPAN>

<SPAN LANG="da-DK">      if (faktor == tal)</SPAN>
<SPAN LANG="da-DK">      {</SPAN>
<SPAN LANG="da-DK">        System.out.print(tal + &quot; er et primtal.\n&quot;);</SPAN>
<SPAN LANG="da-DK">        antalPrimtal = antalPrimtal + 1;</SPAN>
<SPAN LANG="da-DK">      }</SPAN>
<SPAN LANG="da-DK">    }</SPAN>
<SPAN LANG="da-DK">    System.out.println(&quot;Antal primtal i alt: &quot; + antalPrimtal);</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE><P CLASS="western">
Under Linux kan man unders&oslash;ge, hvor lang tid en kommando tager
med 'time'. For at tage tiden p&aring; ovenst&aring;ende program
skriver man:</P>
<PRE CLASS="kode-western">time java Primtal</PRE><P CLASS="western">
... hvorefter programmet k&oslash;rer:</P>
<PRE CLASS="kode-western">50021 er et primtal.
<SPAN LANG="da-DK">50023 er et primtal.</SPAN>
<SPAN LANG="da-DK">...</SPAN>
<SPAN LANG="da-DK">99961 er et primtal.</SPAN>
<SPAN LANG="da-DK">99971 er et primtal.</SPAN>
<SPAN LANG="da-DK">99989 er et primtal.</SPAN>
<SPAN LANG="da-DK">99991 er et primtal.</SPAN>
<SPAN LANG="da-DK">Antal primtal i alt: 4459</SPAN>
<SPAN LANG="da-DK"><B>32.16user</B> 0.19system 0:36.13elapsed 89%CPU (0avgtext+0avgdata 0maxresident)k</SPAN>
<SPAN LANG="da-DK">0inputs+0outputs (5674major+2738minor)pagefaults 0swaps</SPAN></PRE><P CLASS="western">
Sidst udskrives k&oslash;rselstiden. Dette program tager 32.16
sekunders CPU (plus 0.19 sekunders CPU-tid til systemkald).</P>
<H3 CLASS="western">9.3.2 <a name='afsn9.3.2'></a>Testprogrammet i C++</H3>
<P CLASS="western">Lad os nu skrive det tilsvarende program i C++:</P>
<PRE CLASS="kode-western">#include &lt;iostream.h&gt;

<SPAN LANG="da-DK">int main() {</SPAN>
<SPAN LANG="da-DK">  int antalPrimtal = 0;</SPAN>

<SPAN LANG="da-DK">  int tal;</SPAN>
<SPAN LANG="da-DK">  int faktor;</SPAN>

<SPAN LANG="da-DK">  for (tal = 50000; tal&lt;100000; tal++)</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    faktor = 2;</SPAN>

<SPAN LANG="da-DK">    while (tal % faktor &gt; 0) faktor++;</SPAN>

<SPAN LANG="da-DK">    if (faktor == tal)</SPAN>
<SPAN LANG="da-DK">    {</SPAN>
<SPAN LANG="da-DK">      cout&lt;&lt;tal&lt;&lt;&quot; er et primtal.\n&quot;;</SPAN>
<SPAN LANG="da-DK">      antalPrimtal = antalPrimtal + 1;</SPAN>
<SPAN LANG="da-DK">    }</SPAN>
<SPAN LANG="da-DK">  }</SPAN>

<SPAN LANG="da-DK">  cout&lt;&lt;&quot;Antal primtal i alt: &quot;&lt;&lt;antalPrimtal&lt;&lt;&quot;\n&quot;;</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE><P CLASS="western">
Lad sige, at kildeteksten ligger i filen prim.c++. S&aring;
overs&aelig;tter man og k&oslash;rer programmet med:</P>
<PRE CLASS="kode-western">g++ -O3 prim.c++
<SPAN LANG="da-DK">time a.out</SPAN></PRE><P CLASS="western">
Parameteren -O3 fort&aelig;ller overs&aelig;tteren, at den skal
fors&oslash;ge at optimere programmet s&aring; meget som overhovedet
muligt (mildere indstillinger er -O og -O2). Overs&aelig;tteren
generer filen a.out med det eksekverbare program, som udf&oslash;res
og times samtidig:</P>
<PRE CLASS="kode-western">time a.out</PRE><P CLASS="western">
Uddata fra programmet er:</P>
<PRE CLASS="kode-western">...
<SPAN LANG="da-DK">99929 er et primtal.</SPAN>
<SPAN LANG="da-DK">99961 er et primtal.</SPAN>
<SPAN LANG="da-DK">99971 er et primtal.</SPAN>
<SPAN LANG="da-DK">99989 er et primtal.</SPAN>
<SPAN LANG="da-DK">99991 er et primtal.</SPAN>
<SPAN LANG="da-DK">Antal primtal i alt: 4459</SPAN>
<SPAN LANG="da-DK"><B>32.71user</B> 0.08system 0:35.96elapsed 91%CPU (0avgtext+0avgdata 0maxresident)k</SPAN>
<SPAN LANG="da-DK">0inputs+0outputs (200major+27minor)pagefaults 0swaps</SPAN></PRE><P CLASS="western">
Selv med den mest ekstreme optimering af C++-programmet, klarer det
sig alts&aring; lidt d&aring;rligere end Javaprogrammet (dog ikke ret
meget - men uden optimering tager C++-programmet 37 sekunder at
k&oslash;re).</P>
<P CLASS="western">Forklaringen p&aring;, at Java i dette tilf&aelig;lde
er hurtigere end C++, skal nok findes i JIT'ens behandling af
while-l&oslash;kken og if-s&aelig;tningen:</P>
<PRE CLASS="kode-western">      while (tal % faktor &gt; 0) faktor++;
<SPAN LANG="da-DK">      if (faktor == tal)</SPAN></PRE><P CLASS="western">
Eftersom C++-overs&aelig;tteren under overs&aelig;ttelsen og
optimeringen ikke kan vide, om betingelserne som regel er opfyldt
eller ej, m&aring; den pr&oslash;ve at g&aelig;tte - og den g&aelig;tter
sandsynligvis ofte forkert.</P>
<P CLASS="western">JIT'en kan derimod observere k&oslash;rslen nogle
gange og konstatere, at while-betingelsen oftest er opfyldt, mens
if-s&aelig;tningen meget sj&aelig;ldent er det, og generere
maskinkode, der er optimeret derefter.</P>
<H2 CLASS="western">9.4 <a name='afsn9.4'></a>Videre l&aelig;sning</SPAN></H2>
<UL>
  <LI><P CLASS="western"><SPAN LANG="da-DK">P&aring; hjemmesiden
  </SPAN><SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://www.javaperformancetuning.com/"><SPAN LANG="da-DK">http://www.javaperformancetuning.com/</SPAN></A></SPAN><SPAN LANG="da-DK">
  af Jack Shirazi findes tusindvis af tip til, hvordan man kan
  optimere sit program.</SPAN></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Samme forfatter har
  udgivet bogen &quot;Java Performance Tuning&quot;:<BR> p&aring;
  </SPAN><SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://www.oreilly.com/catalog/javapt/"><SPAN LANG="da-DK">http://www.oreilly.com/catalog/javapt/</SPAN></A></SPAN><SPAN LANG="da-DK">.</SPAN></P>
  <LI><P CLASS="western">I n&aelig;ste kapitel er beskrevet, hvordan
  man kalder et eksternt program eller l&aelig;nker noget maskinkode
  fra et andet programmeringssprog ind i ens javaprogram.</P>
</UL>


<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (71% af vrket).
</font>
<br>
nsker du at se de sidste 29% af dette vrk (362838 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
